<?php
namespace PHPMailer\PHPMailer;
class PHPMailer {
  public $isSMTP = false;
  public $Host; public $SMTPAuth=true; public $Username; public $Password; public $SMTPSecure=''; public $Port=25;
  public $From; public $FromName; public $Subject; public $Body; public $AltBody=''; public $isHTML=true;
  private $to = [];

  public function isSMTP(){ $this->isSMTP = true; }
  public function setFrom($from, $name=''){ $this->From=$from; $this->FromName=$name; }
  public function addAddress($addr){ $this->to[] = $addr; }
  public function send(){
    // Minimal SMTP using fsockopen (for shared hosting where mail() disabled).
    // For production, replace with full PHPMailer. This lightweight version supports STARTTLS and basic auth.
    if (!$this->isSMTP) {
      // Try mail()
      $headers = "From: ".$this->FromName." <".$this->From.">\r\n".
                 "MIME-Version: 1.0\r\nContent-type: text/html; charset=UTF-8\r\n";
      return mail(implode(",", $this->to), $this->Subject, $this->Body, $headers);
    }
    $host = $this->Host; $port = $this->Port;
    $fp = fsockopen($host, $port, $errno, $errstr, 20);
    if (!$fp) return false;
    $read = function() use ($fp){ $out=''; while($line=fgets($fp,515)){ $out.=$line; if (preg_match('/^\d{3}\s/', $line)) break; } return $out; };
    $write = function($cmd) use ($fp){ fwrite($fp, $cmd."\r\n"); };
    $read();
    $write("EHLO localhost"); $resp = $read();
    if (strpos($resp, "STARTTLS")!==false){
      stream_socket_enable_crypto($fp, true, STREAM_CRYPTO_METHOD_TLS_CLIENT);
      $write("EHLO localhost"); $read();
    }
    if ($this->SMTPAuth){
      $write("AUTH LOGIN"); $read();
      $write(base64_encode($this->Username)); $read();
      $write(base64_encode($this->Password)); $read();
    }
    $write("MAIL FROM:<".$this->From.">"); $read();
    foreach($this->to as $rcpt){ $write("RCPT TO:<".$rcpt.">"); $read(); }
    $write("DATA"); $read();
    $headers = "From: ".$this->FromName." <".$this->From.">\r\n".
               "MIME-Version: 1.0\r\nContent-type: text/html; charset=UTF-8\r\n".
               "Subject: ".$this->Subject."\r\n";
    $msg = $headers."\r\n".$this->Body."\r\n.";
    fwrite($fp, $msg."\r\n.\r\n");
    $read();
    $write("QUIT"); fclose($fp);
    return true;
  }
}
