<?php
require_once __DIR__ . '/db.php';
header('Content-Type: text/calendar; charset=utf-8');
header('Content-Disposition: attachment; filename="brief.ics"');

$id = $_GET['id'] ?? '';
if (!$id){ http_response_code(400); echo "Invalid"; exit; }
$stmt = $pdo->prepare("SELECT * FROM briefs WHERE id=:id");
$stmt->execute([':id'=>$id]);
$b = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$b){ http_response_code(404); echo "Not found"; exit; }

function dt($s){
  if (!$s) return '';
  $d = new DateTime($s);
  $d->setTimezone(new DateTimeZone('UTC'));
  return $d->format('Ymd\THis\Z');
}
$uid = $b['id'].'@fbc-promo';
$now = (new DateTime('now', new DateTimeZone('UTC')))->format('Ymd\THis\Z');

echo "BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//FBC Promo//EN\n";
foreach (['draft_due'=>'Draft due','final_due'=>'Final due','on_air'=>'On-air/Go-live'] as $k=>$label){
  if ($b[$k]){
    echo "BEGIN:VEVENT\nUID:".$uid."-".$k."\nDTSTAMP:".$now."\nDTSTART:".dt($b[$k])."\nSUMMARY:".$label." – ".str_replace(["\n","\r"],' ',$b['title'])."\nEND:VEVENT\n";
  }
}
echo "END:VCALENDAR";
