<?php
function email_subject_new_brief($brief){
  return "[PROMO] New Brief – " . ($brief['title'] ?? 'Untitled');
}
function email_body_new_brief($brief){
  $types = implode(", ", $brief['types'] ?? []);
  $channels = implode(", ", $brief['channels'] ?? []);
  $html = "<h2>New Promo Brief Submitted</h2>";
  $html .= "<p><strong>Title:</strong> ".htmlspecialchars($brief['title'])."</p>";
  $html .= "<p><strong>Department:</strong> ".htmlspecialchars($brief['department'])."</p>";
  $html .= "<p><strong>Brand:</strong> ".htmlspecialchars($brief['brand'])."</p>";
  $html .= "<p><strong>Types:</strong> ".htmlspecialchars($types)."</p>";
  $html .= "<p><strong>Channels:</strong> ".htmlspecialchars($channels)."</p>";
  $html .= "<p><strong>On-Air:</strong> ".htmlspecialchars($brief['on_air'])."</p>";
  $html .= "<p><strong>Draft Due:</strong> ".htmlspecialchars($brief['draft_due'])." &nbsp; <strong>Final Due:</strong> ".htmlspecialchars($brief['final_due'])."</p>";
  $html .= "<p><strong>Objective:</strong><br>".nl2br(htmlspecialchars($brief['objective']))."</p>";
  $html .= "<hr><p>Open Intake Queue: <em>Login to your dashboard</em></p>";
  return $html;
}
