<?php
require_once __DIR__ . '/constants.php';

$dbPath = __DIR__ . '/../storage/app.sqlite';
$needInit = !file_exists($dbPath);
try {
  $pdo = new PDO('sqlite:' . $dbPath);
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (Exception $e) {
  http_response_code(500);
  echo json_encode(['error'=>'DB connect failed','detail'=>$e->getMessage()]);
  exit;
}

if ($needInit){
  $pdo->exec("PRAGMA journal_mode=WAL;");
  $pdo->exec("CREATE TABLE IF NOT EXISTS briefs (
    id TEXT PRIMARY KEY,
    title TEXT, department TEXT, requester TEXT, email TEXT,
    brand TEXT, campaign_start TEXT, campaign_end TEXT,
    on_air TEXT, draft_due TEXT, final_due TEXT,
    types TEXT, channels TEXT, objective TEXT, must_include TEXT,
    context_json TEXT, state TEXT, created_at TEXT
  );");
  $pdo->exec("CREATE TABLE IF NOT EXISTS settings (
    key TEXT PRIMARY KEY,
    value TEXT
  );");
  // Seed defaults
  $defaults = [
    'departments' => json_encode(["TV","News","Sports","Radio","Marketing","HR","Digital"]),
    'brands' => json_encode([
      ["id"=>"fbc1","name"=>"FBC TV","tone"=>"credible, family-friendly"],
      ["id"=>"fbc2","name"=>"FBC 2","tone"=>"youthful, energetic"],
      ["id"=>"viti","name"=>"Viti+","tone"=>"premium, bold"],
      ["id"=>"2dayfm","name"=>"2Day FM","tone"=>"fun, youthful"],
      ["id"=>"bulafm","name"=>"Bula FM","tone"=>"friendly, Fijian-first"],
      ["id"=>"goldfm","name"=>"Gold FM","tone"=>"classic hits, nostalgic"],
      ["id"=>"rfm","name"=>"Radio Fiji One","tone"=>"informative, national"],
      ["id"=>"rf2","name"=>"Radio Fiji Two","tone"=>"community, heritage"]
    ]),
    'sla_days' => json_encode(DEFAULT_SLA)
  ];
  $stmt = $pdo->prepare("INSERT OR REPLACE INTO settings (key, value) VALUES (:k,:v)");
  foreach($defaults as $k=>$v){ $stmt->execute([':k'=>$k, ':v'=>$v]); }
}

function get_setting($key){
  global $pdo;
  $stmt = $pdo->prepare("SELECT value FROM settings WHERE key=:k");
  $stmt->execute([':k'=>$key]);
  $row = $stmt->fetch(PDO::FETCH_ASSOC);
  return $row ? json_decode($row['value'], true) : null;
}


if ($needInit){
  // embeddings table
  $pdo->exec("CREATE TABLE IF NOT EXISTS embeddings (
    brief_id TEXT PRIMARY KEY,
    vector TEXT
  );");
}
