<?php
require_once __DIR__ . '/ai.php';
require_once __DIR__ . '/cors.php';
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/send_email.php';
require_once __DIR__ . '/email_templates.php';

$input = json_decode(file_get_contents('php://input'), true);
if (!$input){ http_response_code(400); echo json_encode(['error'=>'Invalid JSON']); exit; }

// Basic validation
$title = trim($input['title'] ?? '');
$email = trim($input['email'] ?? '');
if ($title==='' || $email===''){ http_response_code(422); echo json_encode(['error'=>'Title and Requester Email are required']); exit; }

$id = "b_" . time() . "_" . bin2hex(random_bytes(3));
$now = gmdate('c');

$brief = [
  'id'=>$id,
  'title'=>$title,
  'department'=>$input['department'] ?? '',
  'requester'=>$input['requester'] ?? '',
  'email'=>$email,
  'brand'=>$input['brand'] ?? '',
  'campaign_start'=>$input['campaign_start'] ?? '',
  'campaign_end'=>$input['campaign_end'] ?? '',
  'on_air'=>$input['on_air'] ?? '',
  'draft_due'=>$input['draft_due'] ?? '',
  'final_due'=>$input['final_due'] ?? '',
  'types'=>$input['types'] ?? [],
  'channels'=>$input['channels'] ?? [],
  'objective'=>$input['objective'] ?? '',
  'must_include'=>$input['must_include'] ?? '',
  'context_json'=>json_encode($input['context_capture'] ?? new stdClass()),
  'state'=>"Submitted",
  'created_at'=>$now
];

// Insert DB
$stmt = $pdo->prepare("INSERT INTO briefs
  (id,title,department,requester,email,brand,campaign_start,campaign_end,on_air,draft_due,final_due,types,channels,objective,must_include,context_json,state,created_at)
  VALUES (:id,:title,:department,:requester,:email,:brand,:campaign_start,:campaign_end,:on_air,:draft_due,:final_due,:types,:channels,:objective,:must_include,:context_json,:state,:created_at)");
$stmt->execute([
  ':id'=>$brief['id'], ':title'=>$brief['title'], ':department'=>$brief['department'],
  ':requester'=>$brief['requester'], ':email'=>$brief['email'], ':brand'=>$brief['brand'],
  ':campaign_start'=>$brief['campaign_start'], ':campaign_end'=>$brief['campaign_end'],
  ':on_air'=>$brief['on_air'], ':draft_due'=>$brief['draft_due'], ':final_due'=>$brief['final_due'],
  ':types'=>json_encode($brief['types']), ':channels'=>json_encode($brief['channels']),
  ':objective'=>$brief['objective'], ':must_include'=>$brief['must_include'],
  ':context_json'=>$brief['context_json'], ':state'=>$brief['state'], ':created_at'=>$brief['created_at']
]);

// Send emails (Coordinator + Requester)
$subject = email_subject_new_brief($brief);
$html = email_body_new_brief($brief);
$ok1 = send_mail_html(COORDINATOR_EMAIL, $subject, $html);
$ok2 = send_mail_html($brief['email'], $subject, $html);


// Create and store embedding for self-learn
try {
  $embed_text = $brief['title']."\n".$brief['department']."\n".$brief['brand']."\n".implode(',', $brief['types'])."\n".implode(',', $brief['channels'])."\n".$brief['objective'];
  $vec = ai_embed($embed_text);
  $stmt2 = $pdo->prepare("INSERT OR REPLACE INTO embeddings (brief_id, vector) VALUES (:id,:v)");
  $stmt2->execute([':id'=>$id, ':v'=>json_encode($vec)]);
} catch (Exception $e) {
  // ignore embedding failures in demo
}
echo json_encode(['ok'=>true, 'id'=>$id, 'email_coordinator'=>$ok1, 'email_requester'=>$ok2]);

