<?php
function ai_prompt_for_brief($settings, $brief, $similar=[]){
  $brands = $settings['brands'] ?? [];
  $departments = $settings['departments'] ?? [];
  $sla = $settings['sla_days'] ?? [];
  $similar_summ = array_map(function($s){
    return [
      'title'=>$s['title'],
      'department'=>$s['department'],
      'brand'=>$s['brand'],
      'types'=>$s['types'],
      'channels'=>$s['channels'],
      'objective'=>mb_substr($s['objective'] ?? '', 0, 240)
    ];
  }, $similar);
  $payload = [
    'instruction' => 'You are the FBC Promo Assistant. Produce concise, on-brand outputs. Enforce tone/specs per brand and keep within platform limits.',
    'settings' => [
      'departments'=>$departments,
      'brands'=>$brands,
      'sla_days'=>$sla
    ],
    'brief' => $brief,
    'similar_history' => $similar_summ,
    'outputs' => [
      'timeline' => true,
      'deliverables' => true,
      'copy' => [
        'poster_headline'=>true,
        'tv_script_30'=> in_array('tvc_30', $brief['types'] ?? []),
        'radio_script_30'=> in_array('radio_spot', $brief['types'] ?? []),
        'social_captions'=> count(array_intersect($brief['channels'] ?? [], ['FB','IG','X','YT']))>0
      ],
      'qc_checklist' => true
    ]
  ];
  return $payload;
}
