<?php
require_once __DIR__ . '/cors.php';
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/ai.php';
require_once __DIR__ . '/ai_templates.php';

$input = json_decode(file_get_contents('php://input'), true);
if (!$input){ http_response_code(400); echo json_encode(['error'=>'Invalid JSON']); exit; }

$settings = [
  'departments' => get_setting('departments'),
  'brands' => get_setting('brands'),
  'sla_days' => get_setting('sla_days')
];

// Embed current partial brief
$txt = ($input['title'] ?? '')."\n".($input['department'] ?? '')."\n".($input['brand'] ?? '')."\n".implode(',', $input['types'] ?? [])."\n".implode(',', $input['channels'] ?? [])."\n".($input['objective'] ?? '');
$vec = [];
try { $vec = ai_embed($txt); } catch (Exception $e){ $vec = []; }

// Retrieve top similar briefs
$similar = [];
if (!empty($vec)){
  $stmt = $pdo->query("SELECT b.*, e.vector AS v FROM briefs b JOIN embeddings e ON b.id=e.brief_id ORDER BY b.created_at DESC LIMIT 200");
  $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
  $scored = [];
  foreach($rows as $r){
    $v = json_decode($r['v'] ?? '[]', true);
    $score = cosine($vec, $v);
    $r['types'] = json_decode($r['types'] ?? '[]', true);
    $r['channels'] = json_decode($r['channels'] ?? '[]', true);
    $scored[] = ['score'=>$score, 'row'=>$r];
  }
  usort($scored, function($a,$b){ return $a['score']<$b['score'] ? 1 : -1; });
  foreach(array_slice($scored, 0, 5) as $s){ $similar[] = $s['row']; }
}

$prompt = ai_prompt_for_brief($settings, $input, $similar);
$system = "You are an FBC Promo Assistant. Output concise JSON only. Follow tone/specs and keep copy within platform limits.";
$user = json_encode($prompt, JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE);

try {
  $resp = ai_generate($system, $user);
  // Try to find a JSON block
  $json = trim($resp);
  if ($json[0] !== '{'){ $json = preg_replace('/^[^{]*({.*})[^}]*$/s', '$1', $json); }
  $out = json_decode($json, true);
  if (!$out){ $out = ['raw'=>$resp]; }
  echo json_encode(['ok'=>true, 'suggestions'=>$out]);
} catch (Exception $e){
  echo json_encode(['ok'=>false, 'error'=>$e->getMessage()]);
}
