<?php
require_once __DIR__ . '/cors.php';
require_once __DIR__ . '/ai.php';

$input = json_decode(file_get_contents('php://input'), true);
if (!$input){ http_response_code(400); echo json_encode(['error'=>'Invalid JSON']); exit; }
$field = $input['field'] ?? 'objective';
$context = $input['context'] ?? [];
$system = "You help fill a single field for an FBC promo brief. Keep it short, on-brand, and specific. Return plain text only.";
$user = "FIELD: ".$field."\nCONTEXT: ".json_encode($context);

try {
  $resp = ai_generate($system, $user);
  echo json_encode(['ok'=>true, 'text'=>trim($resp)]);
} catch (Exception $e){
  echo json_encode(['ok'=>false, 'error'=>$e->getMessage()]);
}
