<?php
require_once __DIR__ . '/config.php';

function http_json($url, $payload, $headers){
  $ch = curl_init($url);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($ch, CURLOPT_POST, true);
  curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
  curl_setopt($ch, CURLOPT_HTTPHEADER, array_merge(['Content-Type: application/json'], $headers));
  curl_setopt($ch, CURLOPT_TIMEOUT, 45);
  $res = curl_exec($ch);
  $err = curl_error($ch);
  $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
  curl_close($ch);
  if ($err) throw new Exception("HTTP error: ".$err);
  return [$code, $res];
}

function ai_generate($system_or_prompt, $user=null){
  if (AI_PROVIDER === 'openai'){
    $url = 'https://api.openai.com/v1/chat/completions';
    $payload = [
      'model' => OPENAI_MODEL,
      'messages' => $user ? [
        ['role'=>'system','content'=>$system_or_prompt],
        ['role'=>'user','content'=>$user]
      ] : [['role'=>'user','content'=>$system_or_prompt]],
      'temperature'=>0.4
    ];
    list($code, $res) = http_json($url, $payload, ['Authorization: Bearer '.OPENAI_API_KEY]);
    $j = json_decode($res, true);
    if ($code>=300 || !$j) throw new Exception("OpenAI error: ".$res);
    return $j['choices'][0]['message']['content'] ?? '';
  } else {
    // Gemini
    $url = 'https://generativelanguage.googleapis.com/v1beta/models/'.GEMINI_MODEL.':generateContent?key='.urlencode(GEMINI_API_KEY);
    $payload = ['contents'=>[['parts'=>[['text'=>$user? ($system_or_prompt."\n\n".$user):$system_or_prompt]]]]];
    list($code, $res) = http_json($url, $payload, []);
    $j = json_decode($res, true);
    if ($code>=300 || !$j) throw new Exception("Gemini error: ".$res);
    return $j['candidates'][0]['content']['parts'][0]['text'] ?? '';
  }
}

function ai_embed($text){
  if (AI_PROVIDER === 'openai'){
    $url = 'https://api.openai.com/v1/embeddings';
    $payload = ['model'=>OPENAI_EMBED_MODEL, 'input'=>$text];
    list($code, $res) = http_json($url, $payload, ['Authorization: Bearer '.OPENAI_API_KEY]);
    $j = json_decode($res, true);
    if ($code>=300 || !$j) throw new Exception("OpenAI embed error: ".$res);
    return $j['data'][0]['embedding'];
  } else {
    // Gemini embeddings
    $url = 'https://generativelanguage.googleapis.com/v1beta/models/'.GEMINI_EMBED_MODEL.':embedContent?key='.urlencode(GEMINI_API_KEY);
    $payload = {'content': {'parts': [{'text': $text}]}};
    // PHP can't inline JS object; build array
    $payload = ['content'=>['parts'=>[['text'=>$text]]]];
    list($code, $res) = http_json($url, $payload, []);
    $j = json_decode($res, true);
    if ($code>=300 || !$j) throw new Exception("Gemini embed error: ".$res);
    return $j['embedding']['values'] ?? [];
  }
}

function cosine($a, $b){
  $dot=0; $na=0; $nb=0; $N=min(count($a), count($b));
  for($i=0;$i<$N;$i++){ $dot += $a[$i]*$b[$i]; $na += $a[$i]*$a[$i]; $nb += $b[$i]*$b[$i]; }
  if ($na==0 || $nb==0) return 0;
  return $dot / (sqrt($na)*sqrt($nb));
}
