# FBC Promo Brief – Full-Stack (PHP + SQLite + PHPMailer)

This is a **ready-to-deploy** promo brief app for shared hosting (cPanel-friendly).  
It includes a static frontend, a PHP backend (SQLite DB), and **automatic email notifications** via SMTP.

## Features
- Create promo briefs (context-aware types: TVC, posters, motion, etc.).
- Intake queue (list & view briefs).
- .ICS calendar export (Draft / Final / On-Air).
- Automatic email notification on submission (Coordinator + Requester).
- Settings editor (Departments, Brands/Stations, SLA days) stored in DB.
- No Composer required; PHPMailer included.

---

## 1) Deploy
1. Upload the folder contents to your hosting (e.g., `/public_html/fbc-promo/`).
2. Ensure the folder `storage/` is **writable** by PHP (permissions 755 or 775; if needed 777).
3. Copy `backend/config.sample.php` to `backend/config.php` and edit:
   - SMTP host, username, password
   - `MAIL_FROM`, `MAIL_FROM_NAME`
   - `COORDINATOR_EMAIL` (default recipient for new briefs)
   - Allowed origin (your site URL)

> On first request, the app creates `storage/app.sqlite` and tables automatically.

### URLS
- Frontend: `https://yourdomain.com/fbc-promo/public/`
- API base: `https://yourdomain.com/fbc-promo/backend/`

> You can move `public/` to your web root and protect `backend/`/`storage/` as needed.

---

## 2) Configure Email
Edit `backend/config.php`:
```php
define('SMTP_HOST', 'smtp.yourmail.com');
define('SMTP_USER', 'no-reply@yourdomain.com');
define('SMTP_PASS', 'your-password');
define('SMTP_PORT', 587); // or 465 for SMTPS
define('MAIL_FROM', 'no-reply@yourdomain.com');
define('MAIL_FROM_NAME', 'FBC Promo Bot');
define('COORDINATOR_EMAIL', 'promocoord@fbc.com.fj'); // receives new brief alerts
```
Optional: set `FORCE_TO` to route all emails to yourself during testing.

---

## 3) Edit Content (brands, departments, SLA)
Visit `public/admin.html`:
- **Departments** (array)
- **Brands/Stations** (array of objects; id, name, tone, handles)
- **SLA Days** per promo type (JSON map)

Click **Save Settings** → stored in the database.

You can also seed `backend/db_seed.json` before first run.

---

## 4) Security Notes
- This demo has no auth. For internal use, add HTTP Basic Auth or put behind VPN/SSO.
- To lock backend endpoints, configure an `.htaccess` or add token-based checks.
- CORS is limited via `ALLOWED_ORIGIN` in `config.php`.

---

## 5) Files to tweak
- Frontend UI: `public/index.html`, `public/admin.html`, `public/app.js`, `public/styles.css`
- Email template: `backend/email_templates.php` (subject/body)
- SLA logic: `backend/constants.php`
- DB schema: `backend/db.php` (auto-creates tables if missing)

---

## 6) Run locally (optional)
You can test with PHP's built-in server:
```bash
cd backend
php -S 127.0.0.1:8080
```
Then open `public/index.html` and set `API_BASE` to `http://127.0.0.1:8080/` in `public/app.js`.

---

## 7) Roadmap
- User accounts & roles, assignments, comments threads.
- File uploads (deliverables & versioning).
- AI-assisted brief completion (RAG with brand packs).
- Slack/Teams notifications.
- Analytics dashboard with real SLA tracking.

Enjoy!

---

## 8) Enable AI (Gemini or ChatGPT)
This build supports **either Google Gemini or OpenAI ChatGPT** for:
- **AI Assist** in the brief form (auto-fill objective, scripts, captions, deliverables)
- **Self‑learn** patterns from request history via embeddings (stores vectors in SQLite)
- **Suggest** due dates and risk flags using your SLA + on-air dates

### Configure keys
Edit `backend/config.php` (copy from sample if needed):
```php
// AI
define('AI_PROVIDER', 'openai'); // 'openai' or 'gemini'
define('OPENAI_API_KEY', 'sk-...');          // if using OpenAI
define('OPENAI_MODEL', 'gpt-4o-mini');       // chat model
define('OPENAI_EMBED_MODEL', 'text-embedding-3-small');

define('GEMINI_API_KEY', '');                // if using Gemini
define('GEMINI_MODEL', 'gemini-1.5-flash');  // chat model
define('GEMINI_EMBED_MODEL', 'text-embedding-004');
```

### How it works
- On **brief submit**, the text is embedded and stored in `embeddings` for similarity search.
- When you click **AI Assist** in the form, the server:
  1. Embeds your partial brief.
  2. Retrieves similar past briefs (if any).
  3. Builds a brand/process-aware prompt (using your Settings).
  4. Calls the selected provider (OpenAI or Gemini).
  5. Returns structured suggestions (timeline, copy, checklists).

### Endpoints
- `backend/ai_suggest.php` → Whole-brief suggestions
- `backend/ai_field.php` → Single-field auto-complete (e.g., Objective)

If your shared host blocks outbound requests, allow it or run behind a PHP server with internet access.
